// Web server displaying analogue voltage on A0

#include <SPI.h>
#include <Ethernet.h>

// Enter a MAC address and IP address for your controller below.
// The IP address will be dependent on your local network:
byte mac[] = {
  0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED
};

IPAddress ip(192, 168, 1, 177);

// Initialize the Ethernet server library
// with the IP address and port you want to use
// (port 80 is default for HTTP):
EthernetServer server(80);

EthernetClient client;

char line1[100];
char buffer[100];

void setup() {
  Ethernet.begin(mac, ip);
  server.begin();
}


/*

//byte mac[] = { 0xA0, 0xFF, 0xFF, 0xFF, 0xFF, 0x03 };
//byte ip[] = { 198, 168,1, 174 };

//EthernetServer server(80);


void setup()
{
  Serial.begin(9600);
  if (Ethernet.begin(mac, ip)) 
  {
    Serial.println(F("Please enter the following address to display")); 
    Serial.println(F("the analogue voltage in your browser:"));
    Serial.print(F("http://"));
    Serial.println(Ethernet.localIP());
  }
  else
  {
    Serial.println(F("Unable to connect to the network"));
  }
  server.begin();
}

*/
void loop()
{
  client = server.available();
  if (client) 
  {
    if (client.connected()) 
    {
      readHeader();
      if (! pageNameIs("/"))
      {
        client.stop();  
        return;
      }
      client.println(F("HTTP/1.1 200 OK"));
      client.println(F("Content-Type: text/html"));
      client.println();

      sendBody();
      client.stop();            
    }
  }
}

void sendBody()
{
  client.println(F("<html><body bgcolor = #E6E6FA>"));
  sendAnalogReadings();
  client.println(F("<form method='GET'>"));  
  client.println(F("<input type='submit' value='Read voltage'/>"));
  client.println(F("</form>"));
  client.println(F("</body></html>"));
}

void sendAnalogReadings()
{
  client.println(F("<p><h3>"));
  client.println(F("Arduino analog input A0 = "));
  int analogueValue = analogRead(0);
  client.print((float) analogueValue/205);
  client.println(F(" V"));
  client.println(F("</h3></p>"));
}

void readHeader()
{
  readRequestLine(line1);
  while (readRequestLine(buffer) > 1 && buffer[0] != '\n') {}
}

int readRequestLine(char *line)
{
  char ch;
  int i = 0;
  while (ch != '\n' && i < 100 && client.available())
  {
    if (client.available())
    {
      ch = client.read();
      line[i] = ch;
      i ++;
    }
  }
  line[i] = '\0'; 
  return i;
}

boolean pageNameIs(char* name)
{
   // page name starts at char pos 4
   // ends with space
   int i = 4;
   char ch = line1[i];
   while (ch != ' ' && ch != '\n' && ch != '?')
   {
     if (name[i-4] != line1[i])
     {
       return false;
     }
     i++;
     ch = line1[i];
   }
   return true;
}

int valueOfParam(char param)
{
  for (int i = 0; i < strlen(line1); i++)
  {
    if (line1[i] == param && line1[i+1] == '=')
    {
      return (line1[i+2] - '0');
    }
  }
  return 0;
}

