;MAINSMONITOR401A 07DEC07
;set for 3.2768Hz XTAL

#DEFINE BANK0 BCF STATUS,5     ; define STATUS register bit 5 clear as BANK0
#DEFINE BANK1 BSF STATUS,5     ; define STATUS register bit 5 set as BANK1

        List P = PIC16F876A, R=DEC; 
;        List P = PIC16F876, R=DEC;
        __CONFIG h'3F31'  ; 
;         include P16F876.inc
        include P16F876A.inc

           CBLOCK h'20'
RSLINE
LOOP
LOOPA
STORE
STORE1
STORE2

REGA0         ; used by maths routines
REGA1
REGA2
REGA3
REGB0
REGB1
REGB2
REGB3
REGC0
REGC1
REGC2
REGC3

DCOUNT        ; used by BIN2DEC routines
DSIGN
MTEMP  
DIGIT1
DIGIT2
DIGIT3
DIGIT4
DIGIT5
DIGIT6
DIGIT7
DIGIT8
DIGIT9
DIGIT10
MCOUNT

CLKSEC        ; CLOCK main counter - secs
CLKMIN        ; CLOCK - mins
CLKHRS        ; CLOCK - hours
CLKCNT        ; pre-counter for CLOCK

CURRENT3      ; current total MSB
CURRENT2
CURRENT1
CURRENT0      ; current total LSB

SAMPLECOUNT0  ; sample count LSB
SAMPLECOUNT1
SAMPLECOUNT2  ; sample count MSB

PREVMINS

MAINIDCODE
UNITID

RXDATA01
RXDATA02

AVERAGEMSB
AVERAGELSB

INCOMING0
INCOMING1
INCOMING2
INCOMING3
INCOMING4
INCOMING5
INCOMING6
INCOMING7
INCOMING8
INCOMING9
INCOMING10
INCOMING11
IDCOUNT
CHECKSUM

TESTCOUNTER

           ENDC

PROMVAL EQU h'70'              ; in both pages

           ORG 0               ; reset vector
           goto STARTIT
           ORG 4               ; Interrupt vector address
           goto STARTIT
           ORG 5               ; PIC program memory location at which to start 
           goto STARTIT

TABLCD:    addwf PCL,F         ; LCD initialisation table
           retlw b'00110011'   ; initialise lcd - first byte
           retlw b'00110011'   ; 2nd byte (repeat of first)
           retlw b'00110010'   ; set for 4-bit operation
           retlw b'00101100'   ; set for 2 lines
           retlw b'00000110'   ; set entry mode to increment each address
           retlw b'00001100'   ; set display on, cursor off, blink off
           retlw b'00000001'   ; clear display
           retlw b'00000010'   ; return home, cursor & RAM to zero
                               ; end inititalisation table

CHKVAL     addwf PCL,F
           retlw B'01011001'   ; 59 secs max
           retlw B'01011001'   ; 59 mins max
           retlw B'00100011'   ; 23 hours max

; ********

STARTIT:   clrf PORTA          ; clear PORTA's output if any
           clrf PORTB          ; clear PORTB's output if any
           clrf PORTC          ; clear PORTC's output if any

           BANK1
           movlw B'10001110'   ; set for RA0 analog, rest of RA & RE as digital
           movwf ADCON1        ; right justified (8 bit only) (bit 7=1)

           movlw %11001111
           movwf TRISC
           MOVLW %00000000
           MOVWF TRISB 
           movlw %00000001
           MOVWF TRISA     ; RA as input, rest as output
           MOVLW %10000110 ; timer ratio 1:128, PORTB pullups off (bit 7 = 1)
           MOVWF OPTION_REG
           BANK0

           call JOESETBAUD

           movlw %10000001     ; set AD on, Fosc/32, set for RA0
           movwf ADCON0

           call PAUSIT
           call LCDSET
           call PAUSIT

           clrf CLKHRS
           clrf CLKMIN
           clrf CLKSEC
           clrf CURRENT0
           clrf CURRENT1
           clrf CURRENT2
           clrf CURRENT3
           clrf SAMPLECOUNT0
           clrf SAMPLECOUNT1
           clrf SAMPLECOUNT2
           clrf PREVMINS
           clrf RXDATA01
           clrf RXDATA02
           clrf AVERAGEMSB
           clrf AVERAGELSB

           clrf INCOMING0
           clrf INCOMING1
           clrf INCOMING2
           clrf INCOMING3
           clrf INCOMING4
           clrf INCOMING5
           clrf INCOMING6
           clrf INCOMING7
           clrf INCOMING8
           clrf INCOMING9
           clrf INCOMING10

           movlw 25            ;reset start value of CLKCNT
           movwf CLKCNT
           call CLRLINE1
           call CLRLINE2

           call GETIDSWITCH
           call SHOWUNITID

        clrf RXDATA01
;        movlw %00001111
;        movwf UNITID

;        movf UNITID,W
;        xorlw %00001111
;        btfss STATUS,S
;        goto MAIN

;        clrf TESTCOUNTER

;        bsf PORTA,1

MAIN:

MAIN2:     btfss INTCON,2      ; has a timer time-out been detected?
           goto MAIN           ; no
           BCF INTCON,2        ; yes
           decfsz CLKCNT,F     ; decrement clock counter. Is it = 0?
           goto MAIN
           call CLKADD
           movlw 25            ; reset start value of CLKCNT
           movwf CLKCNT

           call SHOWTIME
;           btfsc PORTC,5
           call SENDTIME

;          call GETCURRENT
;          call SHOWADC

           movf CLKMIN,W
           xorwf PREVMINS,W
           btfsc STATUS,Z
           goto MAIN
           movf CLKMIN,W
           movwf PREVMINS
;           call PAUSIT

           call GETCURRENT
           call SHOWCURRENT
           call SHOWADC
           call SENDCURRENT
           call SHOWSAMPLECOUNT
           call GETAVERAGE
;           call SHOWAVERAGE
;           call SENDSAMPLECOUNT
           goto MAIN

; ***********

SHOWTIME:
        call LCD1
        bsf RSLINE,4

        swapf CLKHRS,W
        andlw 15
        iorlw 48
        call LCDOUT

        movf CLKHRS,W
        addwf CHECKSUM,F
        andlw 15
        iorlw 48
        call LCDOUT
        movlw '.'
        call LCDOUT

        swapf CLKMIN,W
        andlw 15
        iorlw 48
        call LCDOUT

        movf CLKMIN,W
        addwf CHECKSUM,F
        andlw 15
        iorlw 48
        call LCDOUT
        movlw ':'
        call LCDOUT

        swapf CLKSEC,W
        andlw 15
        iorlw 48
        call LCDOUT

        movf CLKSEC,W
        addwf CHECKSUM,F
        andlw 15
        iorlw 48
        call LCDOUT
        return

SENDTIME:
        clrf CHECKSUM
;        movlw 18 ;17
        movf UNITID,W
        iorlw %00010000
        call TXBYTE

;        movlw 18 ;17
        movf UNITID,W
        iorlw %00010000
        call TXBYTE
        movwf CHECKSUM

        swapf CLKHRS,W
        andlw 15
        call TXBYTE
        movf CLKHRS,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE
        swapf CLKMIN,W
        andlw 15
        call TXBYTE
        movf CLKMIN,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE
        swapf CLKSEC,W
        andlw 15
        call TXBYTE
        movf CLKSEC,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE
        comf CHECKSUM,W
        call TXBYTE
        return

;********* GET CURRENT VALUE

GETCURRENT: bsf ADCON0,GO      ; start data conversion

GETADC: btfsc ADCON0,GO
        goto GETADC
        movf ADRESH,W          ; get ADC MSB val
        movwf REGA1
        BANK1
        movf ADRESL,W          ; get ADC LSB val
        BANK0

;        incf TESTCOUNTER,f
;        movf testcounter,w

        movwf REGA0
        clrf REGA2
        clrf REGA3

        movf CURRENT0,W
        movwf REGB0
        movf CURRENT1,W
        movwf REGB1
        movf CURRENT2,W
        movwf REGB2
        movf CURRENT3,W
        movwf REGB3
        call ADD

        movf REGA0,W
        movwf CURRENT0
        movf REGA1,W
        movwf CURRENT1
        movf REGA2,W
        movwf CURRENT2
        movf REGA3,W
        movwf CURRENT3

        incfsz SAMPLECOUNT0,F
        return  
        incfsz SAMPLECOUNT1,F
        return
        incf SAMPLECOUNT2,F
        return

SHOWCURRENT:
        call LCD21
        bsf RSLINE,4
        movf CURRENT0,W
        movwf REGA0
        movf CURRENT1,W
        movwf REGA1
        movf CURRENT2,W
        movwf REGA2
        movf CURRENT3,W
        movwf REGA3
        call BIN2DEC

        movf DIGIT2,W
        call LCDOUT
        movf DIGIT3,W
        call LCDOUT

        movf DIGIT4,W
        call LCDOUT
        movf DIGIT5,W
        call LCDOUT
        movf DIGIT6,W
        call LCDOUT

        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SHOWSAMPLECOUNT:
        call LCD30
        bsf RSLINE,4

        movf SAMPLECOUNT0,W
        movwf REGA0
        movf SAMPLECOUNT1,W
        movwf REGA1
        movf SAMPLECOUNT2,W
        movwf REGA2
        clrf REGA3
        call BIN2DEC
        movf DIGIT6,W
        call LCDOUT

        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

GETAVERAGE:
        movf CURRENT0,W
        movwf REGA0
        movf CURRENT1,W
        movwf REGA1
        movf CURRENT2,W
        movwf REGA2
        movf CURRENT3,W
        movwf REGA3

        movf SAMPLECOUNT0,W
        movwf REGB0
        movf SAMPLECOUNT1,W
        movwf REGB1
        movf SAMPLECOUNT2,W
        movwf REGB2
        clrf REGB3
        call DIVIDE32
        movf REGA1,W
        movwf AVERAGEMSB
        movf REGA0,W
        movwf AVERAGELSB
        return

SHOWAVERAGE:
        call LCD10
        bsf RSLINE,4
        call BIN2DEC
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

SHOWADC:
;        movf testcounter,w
;        movwf REGA0
        BANK1
        movf ADRESL,W          ; get ADC MSB val
        BANK0
        movwf REGA0

        movf ADRESH,W          ; get ADC MSB val
        movwf REGA1
        clrf REGA2
        clrf REGA3
        call LCD10
        bsf RSLINE,4
        call BIN2DEC
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        movlw ' '
        call LCDOUT
        movlw ' '
        call LCDOUT
        return

GETIDSWITCH: movf PORTC,W       ; get val of PORTC switch
        andlw %00001111         ; AND to get bits 0-4
;        iorlw %10000000

;        movlw 192
        movwf UNITID
;        swapf UNITID,W
;        iorlw 15
;        movwf UNITID
        return

SHOWUNITID:
        call LCD21
        bsf RSLINE,4
        movlw 'U'
        call LCDOUT
        movlw 'N'
        call LCDOUT
        movlw 'I'
        call LCDOUT
        movlw 'T'
        call LCDOUT
        movlw ' '
        call LCDOUT

        movf UNITID,W
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        call BIN2DEC
;        movf DIGIT7,W
;        call LCDOUT
;        movf DIGIT8,W
;        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT

;        call GETIDSWITCH

;        goto SHOWUNITID

;hereT: nop
;        goto hereT

        return

SHOWMAINID: movf MAINIDCODE,W
        movwf REGA0
        clrf REGA1
        clrf REGA2
        clrf REGA3
        call LCD21
        bsf RSLINE,4
        call BIN2DEC
        movf DIGIT7,W
        call LCDOUT
        movf DIGIT8,W
        call LCDOUT
        movf DIGIT9,W
        call LCDOUT
        movf DIGIT10,W
        call LCDOUT
        return

SENDCURRENT:
;        movlw 34 ;33
        movf UNITID,W
        iorlw %00100000
        call TXBYTE

;        movlw 34 ;33
        movf UNITID,W
        iorlw %00100000
        call TXBYTE         ; stripped at PC
        movwf CHECKSUM

        swapf CURRENT3,W
        andlw 15
        call TXBYTE        ; 1
        movf CURRENT3,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE        ; 2

        swapf CURRENT2,W
        andlw 15
        call TXBYTE        ; 3
        movf CURRENT2,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE        ; 4

        swapf CURRENT1,W
        andlw 15
        call TXBYTE        ; 5
        movf CURRENT1,W
        addwf CHECKSUM,F
        andlw 15           ; 6
        call TXBYTE

        swapf CURRENT0,W
        andlw 15
        call TXBYTE        ; 7
        movf CURRENT0,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE        ; 8

;        return

SENDSAMPLECOUNT:
        swapf SAMPLECOUNT2,W   
        andlw 15
        call TXBYTE       ; send LSB    ;9
        movf SAMPLECOUNT2,W            
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE                     ;10
        swapf SAMPLECOUNT1,W            
        andlw 15
        call TXBYTE                     ;11
        movf SAMPLECOUNT1,W             
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE                     ;12
        swapf SAMPLECOUNT0,W
        andlw 15
        call TXBYTE                     ;13
        movf SAMPLECOUNT0,W
        addwf CHECKSUM,F
        andlw 15
        call TXBYTE                     ;14

        comf CHECKSUM,W
        call TXBYTE                     ; stripped at PC

;        call LCD10
;        bsf RSLINE,4

;        comf CHECKSUM,W
;        movwf REGA0
;        clrf REGA1
;        clrf REGA2
;        clrf REGA3
;        call BIN2DEC

;        movf DIGIT7,W
;        call LCDOUT
;        movf DIGIT8,W
;        call LCDOUT
;        movf DIGIT9,W
;        call LCDOUT
;        movf DIGIT10,W
;        call LCDOUT

        return

SENDAVERAGE:
        swapf AVERAGEMSB,W   
        andlw 15
        call TXBYTE                     ;8
        movf AVERAGEMSB,W            
        andlw 15
        call TXBYTE                     ;9
        swapf AVERAGELSB,W            
        andlw 15
        call TXBYTE                     ;10
        movf AVERAGELSB,W             
        andlw 15
        call TXBYTE                     ;11
        return

PAUSIT:    movlw 5             ; set delay counter to 5
           movwf CLKCNT        ; (for 1/25th sec x 5)
           clrf INTCON         ; clear interupt flag
PAUSE                          ; initial 1/5th sec wait before setting up LCD
           btfss INTCON,2      ; has a timer time-out been detected?
           goto PAUSE          ; no
           bcf INTCON,2        ; yes
           decfsz CLKCNT,F     ; dec counter, is it zero?
           goto PAUSE          ; no
           return              ; yes

; **********

CLKADD          movlw CLKSEC            ;get address of CLKSEC
                movwf FSR               ;move it into indirect reg
                movlw 3                 ;set loop to 3
                movwf LOOP
                clrf STORE1

ADDCLK          incf INDF,F             ;inc units - all in BCD
                movlw 6
                addwf INDF,W            ;if 6 is added is there a digit carry?
                btfsc STATUS,DC
                movwf INDF              ;yes

ADDCL2          movf STORE1,W           ;now check if value > allowed value
                call CHKVAL
                movwf STORE2
                movf INDF,W
                subwf STORE2,F          ;is count =<  than allowed?
                btfsc STATUS,C
                return
                clrf INDF               ;no, it's greater, so clear it

ADDCL2A         incf STORE1,F           ;and add 1 to time loop & byte
                incf FSR,F
                decfsz LOOP,F           ;dec loop, is it = 0?
                goto ADDCLK             ;no
                return

;******** LCD ROUTINES **********

LCD1:   movlw %10000000
        goto LCDLIN
LCD10:  movlw %10001010
        goto LCDLIN
LCD14:  movlw %10001110
        goto LCDLIN

LCD21:  movlw %11000000
        goto LCDLIN
LCD25:  movlw %11000101
        goto LCDLIN
LCD28:  movlw %11001000
        goto LCDLIN
LCD30:  movlw %11001010
        goto LCDLIN

LCD34:  movlw %11001110
        goto LCDLIN
LCD32:  movlw %11001100
        goto LCDLIN

LCDLIN: BCF RSLINE,4

LCDOUT: movwf STORE
        movlw 50
        movwf LOOPA
DELAYIT: decfsz LOOPA,F
        goto DELAYIT
        call SENDIT

SENDIT: swapf STORE,F
        movf STORE,W
        andlw 15
        iorwf RSLINE,W
        movwf PORTB
        BSF PORTB,5
        nop 
        nop
        BCF PORTB,5
        RETURN

;*************

CLRLINE1: call LCD1     ;set address for line 1 cell 1
        bsf RSLINE,4    ;set RS for data send
        clrf LOOP       ;
CLRL1:  movlw ' '       ;clear cell
        call LCDOUT     ;
        incf LOOP,F     ;inc loop
        btfss LOOP,4    ;has last LCD letter been sent?
        goto CLRL1      ;no
        return

CLRLINE2: call LCD21
        bsf RSLINE,4
        movlw 16
        movwf LOOP
CL2:    movlw ' '
        call LCDOUT
        decfsz LOOP,F
        goto CL2
        return

LCDSET: clrf LOOP        ;clr LCD set-up loop
        clrf RSLINE      ;clear RS line for instruction send
LCDST2: movf LOOP,W      ;get table address
        call TABLCD      ;get set-up instruction
        call LCDOUT      ;perform it
        incf LOOP,F      ;inc loop
        btfss LOOP,3     ;has last LCD set-up instruction now been done?
        goto LCDST2      ;no
        return

; ******* WRITE DATA TO EEPROM ROUTINE modified for PIC16F87x devices ********
          ;according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address at which data
                        ;is to be stored. The data to be stored
                        ;is held in STORE1.
SETPRM: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bcf STATUS,RP1  ;set for Page 0
        movf PROMVAL,W  ;STORE1,W   ;get data value from STORE1 and hold in W
        bsf STATUS,RP1  ;set for Page 2
        movwf EEDATA    ;copy W into eeprom data byte register
        bsf STATUS,RP0  ;set for page 3
        bcf EECON1,EEPGD ;point to Data memory
        bsf EECON1,WREN ;enable write flag

MANUAL: movlw $55       ;these lines cause the action required by
        movwf EECON2    ;by the eeprom to store the data in EEDATA
        movlw $AA       ;at the address held by EEADR.
        movwf EECON2
        bsf EECON1,WR   ;set the ``perform write'' flag
        bcf STATUS,RP1  ;set for Page 0
        bcf STATUS,RP0

CHKWRT: btfss PIR2,EEIF ;wait until bit 4 of PIR2 is set
        goto CHKWRT
        bcf PIR2,EEIF   ;clear bit 4 of PIR2
        return

;******** READ DATA FROM EEPROM ROUTINE modified for PIC16F87x devices ****
;         according to data sheet DS30292A page 43

                        ;This routine is entered with W holding
                        ;the eeprom byte address to be read.
PRMGET: bsf STATUS,RP1  ;set for Page 2
        bcf STATUS,RP0
        movwf EEADR     ;copy W into EEADR to set eeprom address
        bsf STATUS,RP0  ;set for Page 3
        bcf EECON1,EEPGD ;point to data memory
        bsf EECON1,RD   ;enable read flag
        bcf STATUS,RP0  ;set for Page 2 
        movf EEDATA,W   ;read eeprom data now in EEDATA into W
        bcf STATUS,RP1  ;set for Page 0
        return

; *********** PART OF PETER HEMSLEY'S 32-BIT MATHS ROUTINES *******

;*** SIGNED BINARY TO DECIMAL ***
;REGA -> DIGITS 1 (MSD) TO 10 (LSD) & DSIGN
;DSIGN = 0 if REGA is positive, FF if negative
;Return carry set if overflow
;Uses FSR register

bin2dec:
        call    clrdig          ;Clear all digits
        clrf    MTEMP           ;Reset sign flag
	call	chksgna		;Make REGA positive
	skpnc
        call    negatea         ;Negative

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

b2dloop	rlf	REGA0,f		;Shift msb into carry
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f

	movlw	DIGIT10
	movwf	FSR		;Pointer to digits
	movlw	D'10'		;10 digits to do
	movwf	DCOUNT

adjlp	rlf	INDF,f		;Shift digit and carry 1 bit left
        movlw   -D'10'
	addwf	INDF,w		;Check and adjust for decimal overflow
	skpnc
	movwf	INDF

	decf	FSR,f		;Next digit
	decfsz	DCOUNT,f
	goto	adjlp

	decfsz	MCOUNT,f	;Next bit
	goto	b2dloop

	btfsc	MTEMP,0		;Check sign
	comf	DSIGN,f		;Negative
	clrc

BLANKIT: movlw 48
        iorwf DIGIT1,F
        iorwf DIGIT2,F
        iorwf DIGIT3,F
        iorwf DIGIT4,F
        iorwf DIGIT5,F
        iorwf DIGIT6,F
        iorwf DIGIT7,F
        iorwf DIGIT8,F
        iorwf DIGIT9,F
        iorwf DIGIT10,F

        movlw 10          ; blank leading zeros
        movwf LOOP
        movlw DIGIT1
        movwf FSR
BLANK:  movf LOOP,W
        movf INDF,W
        andlw 15
        btfss STATUS,Z
        return
        bcf INDF,4
        incf FSR,F
        decfsz LOOP,F
        goto BLANK
        movlw 48
        iorwf DIGIT10,F
        return

; **************

;Set all digits to 0
;Used by bin2dec

clrdig	clrf	DSIGN
	clrf	DIGIT1
	clrf	DIGIT2
	clrf	DIGIT3
	clrf	DIGIT4
	clrf	DIGIT5
	clrf	DIGIT6
	clrf	DIGIT7
	clrf	DIGIT8
	clrf	DIGIT9
	clrf	DIGIT10
	return

;*** SIGNED SUBTRACT ***
;REGA - REGB -> REGA   ;Return carry set if overflow

subtract:
        call    negateb         ;Negate and add
	skpnc
	return			;Overflow

;*** SIGNED ADD ***
;REGA + REGB -> REGA
;Return carry set if overflow

add:    movf    REGA3,w         ;Compare signs
	xorwf	REGB3,w
	movwf	MTEMP

	call	addba		;Add REGB to REGA

	clrc			;Check signs
	movf	REGB3,w		;If signs are same
	xorwf	REGA3,w		;so must result sign
	btfss	MTEMP,7		;else overflow
	addlw	0x80
	return

; **********

;*** SIGNED 32 BIT INTEGER MATHS ROUTINES FOR PIC16 SERIES BY PETER HEMSLEY JAN 2003 ***


;*** SIGNED MULTIPLY ***
;REGA * REGB -> REGA
;Return carry set if overflow

multiply32
	clrf	MTEMP
	call	chksgna		;Make REGA positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make REGB positive
	skpnc
	return			;Overflow

	call	movac		;Move REGA to REGC
	call	clra		;Clear product

	movlw	D'31'		;Loop counter
	movwf	MCOUNT

muloop	call	slac		;Shift left product and multiplicand

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

	btfss	REGC3,7		;If multiplicand bit is a 1 then
	goto	nxtmul
	call	addba		;add multiplier to product

	rlf	REGA3,w
	skpnc			;Check for overflow
	return

nxtmul	decfsz	MCOUNT,f	;Next
	goto	muloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;*** SIGNED DIVIDE ***
;REGA / REGB -> REGA
;Remainder in REGC
;Return carry set if overflow or division by zero

divide32  movf    REGB0,w         ;Trap division by zero
	iorwf	REGB1,w
	iorwf	REGB2,w
	iorwf	REGB3,w
	sublw	0
	skpnc
	return

	clrf	MTEMP
	call	chksgna		;Make dividend (REGA) positive
	skpnc
	return			;Overflow
	call	chksgnb		;Make divisor (REGB) positive
	skpnc
	return			;Overflow

	clrf	REGC0		;Clear remainder
	clrf	REGC1
	clrf	REGC2
	clrf	REGC3

	movlw	D'32'		;Loop counter
	movwf	MCOUNT

dvloop	call	slac		;Shift dividend (REGA) msb into remainder (REGC)

	movf	REGB3,w		;Test if remainder (REGC) >= divisor (REGB)
	subwf	REGC3,w
	skpz
	goto	dtstgt
	movf	REGB2,w
	subwf	REGC2,w
	skpz
	goto	dtstgt
	movf	REGB1,w
	subwf	REGC1,w
	skpz
	goto	dtstgt
	movf	REGB0,w
	subwf	REGC0,w
dtstgt	skpc			;Carry set if remainder >= divisor
	goto	dremlt

	movf	REGB0,w		;Subtract divisor (REGB) from remainder (REGC)
	subwf	REGC0,f
	movf	REGB1,w
	skpc
	incfsz	REGB1,w
	subwf	REGC1,f
	movf	REGB2,w
	skpc
	incfsz	REGB2,w
	subwf	REGC2,f
	movf	REGB3,w
	skpc
	incfsz	REGB3,w
	subwf	REGC3,f
	clrc
	bsf	REGA0,0		;Set quotient bit

dremlt	decfsz	MCOUNT,f	;Next
	goto	dvloop

	btfsc	MTEMP,0		;Check result sign
	call	negatea		;Negative
	return

;UTILITY ROUTINES

;Add REGB to REGA
;Used by add, multiply

addba	movf	REGB0,w		;Add lo byte
	addwf	REGA0,f

	movf	REGB1,w		;Add mid-lo byte
	skpnc			;No carry_in, so just add
	incfsz	REGB1,w		;Add carry_in to REGB
	addwf	REGA1,f		;Add and propagate carry_out

	movf	REGB2,w		;Add mid-hi byte
	skpnc
	incfsz	REGB2,w
	addwf	REGA2,f

	movf	REGB3,w		;Add hi byte
	skpnc
	incf	REGB3,w
	addwf	REGA3,f
	return

;Move REGA to REGC
;Used by multiply, sqrt

movac	movf	REGA0,w
	movwf	REGC0
	movf	REGA1,w
	movwf	REGC1
	movf	REGA2,w
	movwf	REGC2
	movf	REGA3,w
	movwf	REGC3
	return

;Clear REGA
;Used by multiply, sqrt

clra	clrf	REGA0
	clrf	REGA1
	clrf	REGA2
	clrf	REGA3
	return

;Check sign of REGA and convert negative to positive
;Used by multiply, divide, bin2dec

chksgna	rlf	REGA3,w
	skpc
	return

;Negate REGA
;Used by multiply, divide, bin2dec, dec2bin

negatea	movf	REGA3,w		;Save sign in w
	andlw	0x80

	comf	REGA0,f		;2's complement
	comf	REGA1,f
	comf	REGA2,f
	comf	REGA3,f
	incfsz	REGA0,f
	goto	nega1
	incfsz	REGA1,f
	goto	nega1
	incfsz	REGA2,f
	goto	nega1
	incf	REGA3,f
nega1
	incf	MTEMP,f		;flip sign flag
	addwf	REGA3,w		;Return carry set if -2147483648
	return

;Check sign of REGB and negative convert to positive
;Used by multiply, divide

chksgnb	rlf	REGB3,w
	skpc
	return

;Negate REGB
;Used by subtract, multiply, divide

negateb	movf	REGB3,w		;Save sign in w
	andlw	0x80

	comf	REGB0,f		;2's complement
	comf	REGB1,f
	comf	REGB2,f
	comf	REGB3,f
	incfsz	REGB0,f
	goto	negb1
	incfsz	REGB1,f
	goto	negb1
	incfsz	REGB2,f
	goto	negb1
	incf	REGB3,f
negb1
	incf	MTEMP,f		;flip sign flag
	addwf	REGB3,w		;Return carry set if -2147483648
	return

;Shift left REGA and REGC
;Used by multiply, divide

slac	rlf	REGA0,f
	rlf	REGA1,f
	rlf	REGA2,f
	rlf	REGA3,f
	rlf	REGC0,f
	rlf	REGC1,f
	rlf	REGC2,f
	rlf	REGC3,f
	return

       ;*************** OUTPUT TO PC SERIAL PORT FOR DOWNLOAD

;  Modified from Joe Farr's file SAMPLE5.ASM
;  Orig Date: 10-Feb-2003, mod date 01MAR03

JOESETBAUD: BANK1               ; Configure the baud rate generator
;        movlw 25                ; BRG for 9600baud from 4MHz, brgh=1
        movlw 84                ; BRG for 2400baud from 3.2768MHz, brgh=1
;        movlw 103               ; BRG for 2400baud from 4MHz, brgh=1
;        movlw 129               ; BRG for 9600baud from 20MHz, brgh=1
;        movlw 20                ; BRG for 9600baud from 3.2768MHz, brgh=1
        movwf   SPBRG           ; In bank 1
        movlw   b'00100100'     ; BRGH = 1(High speed, bit 2) & ASYNC transmission (bit 5)
        movwf   TXSTA           ; In bank 1
        bcf 	STATUS,RP0  	; back to RAM page 0
        movlw   b'10010000'     ; ASYNC reception
        movwf   RCSTA           ; In bank 0
        call    FlushRXBuffer   ; Flush the RX buffer in bank 0
        return

; Send byte in W to the USART

TxByte: nop
        btfss   PIR1,TXIF       ; TX Buffer empty yet ?
        goto    TxByte          ; No - Keep waiting
        movwf   TXREG           ; Now empty - send this character
        return

; Flush the contents of the RX Buffer

FlushRXBuffer:
	movf    RCREG,W        	; Flush the RX buffer in bank 0
        movf    RCREG,W
        movf    RCREG,W
        return

        org H'2100'      ; data eeprom address
        DE 0             ; 0
        DE 0             ; 1
        DE 0             ; 2
        DE 0             ; 3
        DE 0             ; 4
        DE 0             ; 5
        DE 0             ; 6
        DE 0             ; 7
        DE 0             ; 8
        DE 0             ; 9
        DE 0             ; 10
        DE 0             ; 11
        DE 0             ; 12
        DE 0             ; 13
        DE 0             ; 14
        DE 0             ; 15
        DE 0             ; 16

        END
